var b_fadey = 0;
var max_b_fadey = 60;
var max_b2_fadey = 50;
var min_b2_fadey = 35;
var fade_change_flag = false;



function StartBoss1Fade()
{
	var s_x = cam_xoff;
	var s_y = cam_yoff;

	var cfr = 80;
	var dx = (3*16-s_x)/cfr;
	var dy = (-64-s_y)/cfr;

	for (kl=1;kl<cfr+1;kl++)
	{
		Queue_Command("cam_xoff = "+(s_x+dx*kl)+"; cam_yoff = "+(s_y+dy*kl)+";", kl);
	}



	b_fadey = 0;
	SetLayerMask(1, CreateColor(255-255*b_fadey/max_b_fadey,255-235*b_fadey/max_b_fadey,255-250*b_fadey/max_b_fadey,255));
	Queue_Command("SetFade();",1);
}

function SetFade()
{
	b_fadey++;
	
	if (g_boss_active == 2 && b_fadey < max_b2_fadey && b_fadey > min_b2_fadey)
		fade_change_flag = true;
	
	if (g_boss_active == 2 && b_fadey > max_b2_fadey && fade_change_flag)
		SetLayerMask(1, CreateColor(255-250*max_b2_fadey/max_b_fadey,255-235*max_b2_fadey/max_b_fadey,255-250*max_b2_fadey/max_b_fadey,255));
	else if (g_boss_active == 2 && b_fadey < min_b2_fadey && fade_change_flag)
		SetLayerMask(1, CreateColor(255-250*min_b2_fadey/max_b_fadey,255-235*min_b2_fadey/max_b_fadey,255-250*min_b2_fadey/max_b_fadey,255));
	else
		SetLayerMask(1, CreateColor(255-250*b_fadey/max_b_fadey,255-235*b_fadey/max_b_fadey,255-250*b_fadey/max_b_fadey,255));

	if (b_fadey < max_b_fadey)
		Queue_Command("SetFade();",1);
	else
	{
		Queue_Command("DesetFade();",50);
		
	}
}


function DesetFade()
{
	b_fadey--;

	if (g_boss_active == 2 && b_fadey < max_b2_fadey && b_fadey > min_b2_fadey)
		fade_change_flag = true;

	if (g_boss_active == 2 && b_fadey > max_b2_fadey && fade_change_flag)
		SetLayerMask(1, CreateColor(255-250*max_b2_fadey/max_b_fadey,255-235*max_b2_fadey/max_b_fadey,255-250*max_b2_fadey/max_b_fadey,255));
	else if (g_boss_active == 2 && b_fadey < min_b2_fadey && fade_change_flag)
		SetLayerMask(1, CreateColor(255-250*min_b2_fadey/max_b_fadey,255-235*min_b2_fadey/max_b_fadey,255-250*min_b2_fadey/max_b_fadey,255));
	else
		SetLayerMask(1, CreateColor(255-250*b_fadey/max_b_fadey,255-235*b_fadey/max_b_fadey,255-250*b_fadey/max_b_fadey,255));

	if (b_fadey > 0)
		Queue_Command("DesetFade();",1);
	else
	{
		Queue_Command("SetFade();",50);
		
	}
}

function BossFadeRender()
{
	Rectangle(0,0,GetScreenWidth(),GetScreenHeight(), CreateColor(0,0,0,245*b_fadey/max_b_fadey));
}

var boss_base = LoadSurface("./boss/boss1_base.png")
var boss_basei = LoadImage("./boss/boss1_base.png")
var boss_eye1 = LoadImage("./boss/boss1_eye1.png")
var boss_eye2 = LoadImage("./boss/boss1_eye2.png")
var boss_eyeb = LoadImage("./boss/boss1_eyeb.png")
var boss_mouth1 = LoadImage("./boss/boss1_mouth1.png")
var boss_mouth2 = LoadImage("./boss/boss1_mouth2.png")
var boss_mouthb = LoadImage("./boss/boss1_mouthb.png")
var boss_nose1 = LoadImage("./boss/boss1_nose1.png")
var boss_nose2 = LoadImage("./boss/boss1_nose2.png")
var boss_noseb = LoadImage("./boss/boss1_noseb.png")
var boss_blobs1 = LoadSurface("./boss/boss1_blobs1.png")
var boss_blobs1i = LoadImage("./boss/boss1_blobs1.png")

var boss_mask = LoadSurface("./boss/boss1_mask.png")


var bcolours = new Array();
var max_boss_colours = 9;
for (i=0;i<max_boss_colours;i++)
{
	bcolours[i] = new Object();
	bcolours[i].cd = 0;
	bcolours[i].r = 0;
	bcolours[i].g = 0;
	bcolours[i].b = 0;
	bcolours[i].sx = 0;
	bcolours[i].sy = 0;
	bcolours[i].cx = 0;
	bcolours[i].cy = 0;
}

var tcolor;

for(j=0;j<boss_mask.height;j++)
{
	for(i=0;i<boss_mask.width;i++)
	{
		tcolor = boss_mask.getPixel(i,j);
		if (tcolor.red > 0)
		{
			for (k=0;k<max_boss_colours;k++)
			{
				if (bcolours[k].r == tcolor.red && bcolours[k].g == tcolor.green && bcolours[k].b == tcolor.blue)
				{
					bcolours[k].cx = Math.floor((bcolours[k].sx+i)/2);
					bcolours[k].cy = Math.floor((bcolours[k].sy+j)/2);
					k=max_boss_colours;
				}
				else if (bcolours[k].cd == 0)
				{
					bcolours[k].cd = 1;
					bcolours[k].hp = 15;
					bcolours[k].sx=i;
					bcolours[k].sy=j;

					bcolours[k].r=tcolor.red;
					bcolours[k].g=tcolor.green;
					bcolours[k].b=tcolor.blue;
					k = max_boss_colours;
				}
			}
		}
	}
}



function MakeBossBleed(num, damage)
{
	var sx = -3;
	var sy = -4;
	boss.scream = scream_max;
	PlaySound(84);
	if (boss.platforms != 0)
		PlaySound(127);
	boss.platforms = 0;
	
	LayPlatforms();
	bcolours[num].hp -= damage;
	//spawnblood
	for(dbh=0;dbh<3;dbh++)
		SpawnBlood(boss.x+bcolours[num].cx,boss.y+bcolours[num].cy,sx+Math.random()*damage/2-damage/4,sy+Math.random()*3-2,1, "");
	//spawnsound

	if (bcolours[num].hp <= 0)
	{
		boss.stage_p--;
		//modify the spriteset;
		var temp = CreateColor(255, 255, 255, 255);//CreateColor(bcolours[num].r, bcolours[num].g, bcolours[num].b, 255);
		boss_mask.replaceColor(CreateColor(bcolours[num].r, bcolours[num].g, bcolours[num].b, 0), temp);
		boss_mask.setBlendMode(SUBTRACT);
		boss_blobs1.setBlendMode(ADD);
		boss_blobs1.blitSurface(boss_mask, 0, 0);
		boss_blobs1.replaceColor(temp, CreateColor(0,0,0,0));

		boss_mask.replaceColor(temp, CreateColor(bcolours[num].r, bcolours[num].g, bcolours[num].b, 0));//bcolours[num]);
		boss_mask.setBlendMode(REPLACE);
		boss_blobs1.setBlendMode(REPLACE);
		boss_blobs1i = boss_blobs1.createImage();
			
		for (sn = 0; sn<3+Math.floor(2*Math.random());sn++)
		{
			SpawnGuts(-4, bcolours[num].cx+boss.x,bcolours[num].cy+boss.y,-4*Math.random()-1,-4-2*Math.random(), "boss_gut"+(Math.floor(3*Math.random()) + 1), false, gut_layer+Math.floor(2*Math.random()));
		}
	
		bcolours[num].hp = 0;
	}

}




var boss = new Object();

boss.x = 69*16+128*16;
boss.y = 57*16;
boss.ex = 69*16+128*16;//72*16;
boss.ey = 57*16;//64*16;
boss.mx = 69*16+128*16;//72*16;
boss.my = 57*16;//66*16;

boss.hx = 73*16+8+128*16;//72*16;
boss.hy = 65*16+8;//64*16;
boss.ambpause = false;

boss.mframe = 0;
boss.eframe = 0;
boss.nframe = 0;
boss.counter = 0;
boss.bcount = 0;
boss.bcount_max = 50;
boss.platforms = 0;
boss.pcount = 0;
boss.pcount_max = 0;
boss.plattimer = 0;
boss.plattimermax = 200;

boss.jcount = 0;

boss.hp = 100000;
boss.maxhp = 100000;

boss.stage_p = 9;
boss.stage_m = 9;


boss.hp1 = 30;
boss.maxhp1 = 30;

boss.stage = 1;
boss.ambcount = 1;
boss.scream = 0;
scream_max = 60;


var g_boss_active = 0



function StartBoss2()
{
	//some kind of intro here:

	//block off the rear.
	for (i=0;i<2;i++)
	{
		for (j=0;j<5;j++)
		{
		SetTile(51+i+128,68+j,0,4)
		}
	}
	
	//setup the drawing:
	SetLayerRenderer(2, "DrawBoss();");
	
	for (k=0;k<max_boss_colours;k++)
		bcolours[k].hp = 15;
	boss_blobs1 = LoadSurface("./boss/boss1_blobs1.png")
	boss_blobs1i = LoadImage("./boss/boss1_blobs1.png")

	boss.stage_p = 9;//9;//1 for test
	boss.stage = 0;
	boss.ambcount = 0;
	boss.ambpause = false;
	boss.platforms = 0;
	g_boss_active = 1;
	fade_change_flag = false;
	
	MakeTransition(5);
//	BossAI();
}

function BossAI()
{
		if (entities[0].x > 70*16+128*16)
			entities[0].x = 70*16+128*16;
		if (boss.scream>0)
		{
			boss.stage = 0;
			boss.scream--;
			boss.jcount=0;
			
			if (boss.scream == 30 && boss.stage_p <=0)
			{
				if (music[19].isPlaying() == true)
				{
					music[19].setVolume(0);
					music[19].stop();
					
					music[26].play(false);
					music[26].setVolume(music_vol[26]);
					
					music[1].play(false);
					music[1].pause();
				}
				BossDeath1();
			}
		}
		boss.counter++;
		if (boss.counter%20 ==0)
			boss.mframe=0;
		if (boss.counter%20 ==2)
			boss.mframe=1;
		if (boss.counter%20 ==4)
			boss.mframe=2;
		if (boss.counter%20 ==12)
			boss.mframe=1;
		if (boss.counter%20 ==14)
			boss.mframe=0;
		

		if (boss.counter%60 ==10)
			boss.eframe=0;
		if (boss.counter%60 ==11)
			boss.eframe=1;
		if (boss.counter%60 ==12)
			boss.eframe=2;
		if (boss.counter%60 ==13)
			boss.eframe=1;
		if (boss.counter%60 ==14)
			boss.eframe=0;
/*
		if (boss.counter%(2*boss.bcount_max) < boss.bcount)
			boss.bcount = boss.counter%(2*boss.bcount_max);
		else 
			boss.bcount = boss.bcount_max-boss.counter%(boss.bcount_max);
*/
		if (boss.counter%(2*boss.bcount_max) < boss.bcount_max)
			boss.bcount = boss.counter%boss.bcount_max;
		else 
			boss.bcount = boss.bcount_max-boss.counter%boss.bcount_max;

		if (boss.platforms == 0 && boss.stage == 1)
		{
			boss.pcount++;
			
		}

		if (boss.platforms > 0)
		{
			if (boss.jcount %50 == 15)
			{
				PlaySound(132);
			}
		
			boss.jcount++;
			//do electric attacks here
			if (boss.jcount %60>50)
			{
				BossJellyAttack();
			}

			if (GetTile(52+128,68, 0) == 4)
			{
				//cage is open
				boss.plattimer++;
				if (boss.plattimer > boss.plattimermax)
				{
					boss.stage = 0;
					boss.jcount=0;
					PlaySound(127);
					boss.platforms=0;
					LayPlatforms();
				}
			}
		}

		if (boss.counter%60 == 0)
		{
		//
			if (boss.platforms == 0 && boss.stage == 0 && boss.ambpause == false && boss.stage_p > 0)
			{
				boss.ambpause = true;
				//spawn the enemy ambush
				SpawnBossAmbush();
				boss.pcount = 0;
				

			}
			else if (boss.platforms == 0 && boss.stage == 1 && boss.pcount > 0 && boss.stage_p > 0)
			{
				boss.ambpause = false;
				if (boss.platforms != 1)
					PlaySound(126);
				boss.platforms=1;
				boss.plattimer = 0;

				LayPlatforms();
			}
		}


		if (boss.counter%5 ==2)
		{
			boss.nframe=(boss.nframe+1)%4;
		}
}

function BossJellyAttack()
{
	for (b=0;b<9;b++)
	{
		if (bcolours[b].hp > 0)
			break;
	}
	if (b==9)
		return;
	
	var bca = new Array();
	for (b=0;b<9;b++)
	{
		bca[b] = 0;
	}
	var ct = 0;

	for (b=0;b<9;b++)
	{
		if (bcolours[b].hp > 0)
		{
			bca[ct] = b;
			ct++;
		}
	}
	
	var num = Math.floor(Math.random()*ct);
	num = bca[num];

	var rx = Math.random()*16-8;
	var ry = Math.random()*16-8;

	
	Queue_Command("DoJellyAttack2("+(boss.x+bcolours[num].cx)+", "+(boss.y+bcolours[num].cy)+","+(entities[0].x+rx)+","+(entities[0].y+ry)+");", 16);
}

function SpawnBossAmbush()
{
	boss.ambcount++;
	
	if (boss.ambcount >= 9)
	{
		OpenBossCage();
	}
	if (boss.ambcount < 2)
		StartBattleZone(45);
	else if (boss.ambcount < 3)
		StartBattleZone(46);
	else if (boss.ambcount < 5)
		StartBattleZone(47);
	else if (boss.ambcount < 7)
	{
		StartBattleZone(61);
	}
	else if (boss.ambcount < 9)
	{
		StartBattleZone(62);
	}
	else if (boss.ambcount < 11)
	{
		StartBattleZone(48);
	}
	else if (boss.ambcount < 13)
	{
		StartBattleZone(49);
	}
	else
	{
		StartBattleZone(60);
	}
}

function OpenBossCage()
{
	for (xi=30+128;xi<32+128;xi++)
	{
		for (xj=69;xj<73;xj++)
		{
			SetTile(xi,xj, 0, 4);
		}
	}
	for (xi=32+128;xi<53+128;xi++)
	{
		for (xj=69;xj<73;xj++)
		{
			SetTile(xi,xj, 0, 0);
		}
	}
	SetTile(49+128,68, 0, 0);
	SetTile(50+128,68, 0, 0);
	SetTile(51+128,68, 0, 0);
	SetTile(52+128,68, 0, 0);
}


function CloseBossCage()
{
//	return;
	for (xi=30+128;xi<32+128;xi++)
	{
		for (xj=69;xj<73;xj++)
		{
			SetTile(xi,xj, 0, 4);
		}
	}
	for (xi=32+128;xi<53+128;xi++)
	{
		for (xj=69;xj<73;xj++)
		{
			SetTile(xi,xj, 0, 4);
		}
	}
	SetTile(49+128,68, 0, 4);
	SetTile(50+128,68, 0, 4);
	SetTile(51+128,68, 0, 4);
	SetTile(52+128,68, 0, 4);

	var flag = false;
	for (den=0;den<max_entities;den++)
	{
		if ((entities[den].type > 0&& entities[den].hp > 0)|| den == 0)
		{
			t_layer = GetPersonIDLayer(entities[den].id1);
			SetPersonIDLayer(entities[den].id1, 0);
			if (IsPersonIDObstructed(entities[den].id1, entities[den].x, entities[den].y))
			{
				for (xi=32+128;xi<53+128;xi++)
				{
					for (xj=69;xj<73;xj++)
					{
						SetTile(xi,xj, 0, 0);
					}
				}
				SetTile(49+128,68, 0, 0);
				SetTile(50+128,68, 0, 0);
				SetTile(51+128,68, 0, 0);
				SetTile(52+128,68, 0, 0);
//				SetTile(tdx+2,tdy,0,279);
				if (!IsPersonIDObstructed(entities[den].id1, entities[den].x, entities[den].y))
				{
					//keep it open
					flag = true;
				}
				else
				{
					for (xi=30+128;xi<32+128;xi++)
					{
						for (xj=69;xj<73;xj++)
						{
							SetTile(xi,xj, 0, 4);
						}
					}
					for (xi=32+128;xi<53+128;xi++)
					{
						for (xj=69;xj<73;xj++)
						{
							SetTile(xi,xj, 0, 4);
						}
					}
					SetTile(49+128,68, 0, 4);
					SetTile(50+128,68, 0, 4);
					SetTile(51+128,68, 0, 4);
					SetTile(52+128,68, 0, 4);
//					SetTile(tdx+2,tdy,0,4);
				}
			}
			SetPersonIDLayer(entities[den].id1, t_layer);
		}
	}
	
	if (flag==false)
	{
		for (xi=30+128;xi<32+128;xi++)
		{
			for (xj=69;xj<73;xj++)
			{
				SetTile(xi,xj, 0, 4);
			}
		}
		for (xi=32+128;xi<53+128;xi++)
		{
			for (xj=69;xj<73;xj++)
			{
				SetTile(xi,xj, 0, 4);
			}
		}
		SetTile(49+128,68, 0, 4);
		SetTile(50+128,68, 0, 4);
		SetTile(51+128,68, 0, 4);
		SetTile(52+128,68, 0, 4);
	}
	else
	{
		for (xi=32+128;xi<53+128;xi++)
		{
			for (xj=69;xj<73;xj++)
			{
				SetTile(xi,xj, 0, 0);
			}
		}
		SetTile(49+128,68, 0, 0);
		SetTile(50+128,68, 0, 0);
		SetTile(51+128,68, 0, 0);
		SetTile(52+128,68, 0, 0);
	
		Queue_Command("CloseBossCage();", 8);
	}
}

function CleanGuts()
{
	var maxy = 100;
	if (max_guts > maxy)
	{
		for (cg=0;cg<max_guts-maxy;cg++)
		{
			guts[cg].x = blood_dx;
			SetPersonIDX(guts[cg].id1, blood_dx);
		
		}
	}

}

function DoBossHp1Damage(damage)
{
	var sx = -3;
	var sy = -4;
	//spawn some"blood"
	for(dbh=0;dbh<3;dbh++)
		SpawnBlood(boss.hx,boss.hy,sx+Math.random()*damage/2-damage/4,sy+Math.random()*3-2,1, "", undefined,undefined,true);

	boss.hp1 -= damage;
	if (boss.hp1<0)
	{
		boss.hp1 = boss.maxhp1;
		if (boss.platforms < 3)
		{
			PlaySound(126);
			boss.platforms=(boss.platforms+1)%4;
			LayPlatforms();
		}
		if (boss.platforms == 0)
		{
			boss.stage = 0;
		}
	}
}

function DrawBoss()
{
	var temp = boss.bcount/boss.bcount_max;

	boss_basei.blit(MapToScreenX(0, boss.x), MapToScreenY(0, boss.y));

	if (boss.scream > 3 || boss.jcount > 3 || boss.stage_p<=0)
		boss_eye2.blit(MapToScreenX(0, boss.ex), MapToScreenY(0, boss.ey));
	else if(boss.scream > 0 || (boss.jcount > 0 && boss.jcount < 4))
		boss_eye1.blit(MapToScreenX(0, boss.ex), MapToScreenY(0, boss.ey));
	else if (boss.eframe == 0)
		boss_eyeb.blit(MapToScreenX(0, boss.ex), MapToScreenY(0, boss.ey));
	else if (boss.eframe == 1 || boss.eframe == 3) 
		boss_eye1.blit(MapToScreenX(0, boss.ex), MapToScreenY(0, boss.ey));
	else if (boss.eframe == 2)
		boss_eye2.blit(MapToScreenX(0, boss.ex), MapToScreenY(0, boss.ey));


	if (boss.scream > 3)
		boss_mouth2.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));
	else if(boss.scream > 0)
		boss_mouth1.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));
	else if (boss.mframe == 0)
		boss_mouthb.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));
	else if (boss.mframe == 1 || boss.mframe == 3) 
		boss_mouth1.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));
	else if (boss.mframe == 2)
		boss_mouth2.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));

	if (boss.nframe == 0)
		boss_noseb.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));
	else if (boss.nframe == 1 || boss.nframe == 3) 
		boss_nose1.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));
	else if (boss.nframe == 2)
		boss_nose2.blit(MapToScreenX(0, boss.mx), MapToScreenY(0, boss.my));

	boss_blobs1i.blitMask(MapToScreenX(0, boss.x), MapToScreenY(0, boss.y), CreateColor(255-250*temp,255-235*temp,255-250*temp,255));
}

function LayPlatforms()
{
	if (boss.platforms == 0)
	{
		SetTile(58+128,70,0,279);
		SetTile(59+128,70,0,279);
//		SetTile(60,70,0,279);
		SetTile(62+128,67,0,279);
		SetTile(63+128,67,0,279);
//		SetTile(64,67,0,279);
		SetTile(66+128,64,0,279);
		SetTile(67+128,64,0,279);
//		SetTile(68,64,0,279);

		SetTile(58+128,70,2,2060);
//		SetTile(59,70,2,2061);
		SetTile(59+128,70,2,2062);

		SetTile(62+128,67,2,2060);
//		SetTile(63,67,2,2061);
		SetTile(63+128,67,2,2062);

		SetTile(66+128,64,2,2060);
//		SetTile(67,64,2,2061);
		SetTile(67+128,64,2,2062);
	}

	if (boss.platforms > 0)
		SetPlatform(boss.platforms);
}

function SetPlatform(num)
{
	var tdx,tdy;
	var flag = false;
	if (num == 1)
	{
		tdx = 58+128;
		tdy = 70;
		if (boss.platforms < 1)
			return;
	}
	if (num == 2)
	{
		tdx = 62+128;
		tdy = 67;
		if (boss.platforms < 2)
			return;
	}
	if (num == 3)
	{
		tdx = 66+128;
		tdy = 64;
		if (boss.platforms < 3)
			return;
	}

	SetTile(tdx,tdy,0,4);
	SetTile(tdx+1,tdy,0,4);
//	SetTile(tdx+2,tdy,0,4);
	for (den=0;den<max_entities && flag == false;den++)
	{
		if ((entities[den].type > 0&& entities[den].hp > 0)|| den == 0)
		{
			t_layer = GetPersonIDLayer(entities[den].id1);
			SetPersonIDLayer(entities[den].id1, 0);
			if (IsPersonIDObstructed(entities[den].id1, entities[den].x, entities[den].y))
			{
				SetTile(tdx,tdy,0,279);
				SetTile(tdx+1,tdy,0,279);
//				SetTile(tdx+2,tdy,0,279);
				if (!IsPersonIDObstructed(entities[den].id1, entities[den].x, entities[den].y))
				{
					//keep it open
					flag = true;
				}
				else
				{
					SetTile(tdx,tdy,0,4);
					SetTile(tdx+1,tdy,0,4);
//					SetTile(tdx+2,tdy,0,4);
				}
			}
			SetPersonIDLayer(entities[den].id1, t_layer);
		}
	}

	if (flag == true)
	{
		Queue_Command("SetPlatform("+num+");", 4);
	}
	else
	{
		if (num == 2)
			CleanGuts();


		SetTile(tdx,tdy,2,2080);
//		SetTile(tdx+1,tdy,2,2081);
		SetTile(tdx+1,tdy,2,2082);
	}

}

function BossDeath1()
{
	var tw = 16;
	var th = 16;
	var chance = 0.25;
	var start_x = 70+128;
	var start_y = 57;
	var end_x = 78+128;
	var end_y = 73;

	for (zi=start_x;zi<end_x;zi++)
	{
		for (zj=start_y;zj<end_y;zj++)
		{
			if (Math.random()<chance)
				Queue_Command("SpawnExplosion("+(zi*tw+GetTileWidth()*Math.random())+","+(zj*th+GetTileHeight()*Math.random())+", 0.5, 0, "+(1*(Math.random()*0.75+0.75))+");", 1+Math.floor(Math.random()*16));
			if (Math.random()<chance)
				Queue_Command("SpawnExplosion("+(zi*tw+GetTileWidth()*Math.random())+","+(zj*th+GetTileHeight()*Math.random())+", 0.5, 0, "+(1*(Math.random()*0.75+0.75))+");", 17+Math.floor(Math.random()*16));
			if (Math.random()<chance)
				Queue_Command("SpawnExplosion("+(zi*tw+GetTileWidth()*Math.random())+","+(zj*th+GetTileHeight()*Math.random())+", 0.5, 0, "+(1*(Math.random()*0.75+0.75))+");", 33+Math.floor(Math.random()*16));
			if (Math.random()<chance)
				Queue_Command("SpawnExplosion("+(zi*tw+GetTileWidth()*Math.random())+","+(zj*th+GetTileHeight()*Math.random())+", 0.5, 0, "+(1*(Math.random()*0.75+0.75))+");", 49+Math.floor(Math.random()*16));
		}
	}
	Queue_Command("EndBossPhase1();", 49);


}

function EndBossPhase1()
{
	for (xi=70+128;xi<78+128;xi++)
	{
		for (yi=50;yi<76;yi++)
		{
			SetTile(xi,yi, 2,0);
		}
	}

	for (xi=205;xi<212;xi++)
	{
		for (yi=50;yi<76;yi++)
		{
			SetTile(xi,yi, 2,0);
		}
	}


	for (xi=140;xi<160;xi++)
	{
		for (yi=68;yi<76;yi++)
		{
			SetTile(xi,yi, 2,0);
		}
	}

	
	//set the tiles at the rear
	for (xi=-128+23+128;xi<56+128;xi++)
	{
		for (yi=65;yi<73;yi++)
		{
			SetTile(xi,yi, 0,0);
			
			if ((xi%2 == 0 && yi%2 == 0)||(xi%2 == 1 && yi%2 == 1))
			{
				SetTile(xi,yi, 1,2047);
				SetTile(xi+1,yi, 1,2048);
			}
			else if (xi == 23+128 && yi%2 == 0)
			{
				SetTile(xi,yi, 1,2048);
			}
		}
	}

	for (xi=-128+23+128;xi<56+128;xi++)
	{
		for (yi=63;yi<76;yi++)
		{
			if (yi < 65|| yi > 73)
				SetTile(xi,yi, 0,1);
			else if (yi==73)
				SetTile(xi,yi, 0,2);
			else
				SetTile(xi,yi, 0,0);
		}
	}
	
	for (xi=-128+23+128-2;xi<-128+23+128;xi++)
	{
		for (yi=63;yi<76;yi++)
		{
			SetTile(xi,yi, 0,1);
		}
	}
	

	for (xi=-128+23+128;xi<56+128;xi++)
	{
		for (yi=69;yi<73;yi++)
		{
			SetTile(xi,yi, 0,0);
		}
	}

	for (xi=-128+23+128;xi<48+128;xi++)
	{
		for (yi=56;yi<64;yi++)
		{
			if ((xi+yi)%2 == 0)
				SetTile(xi,yi, 1,2030);
			else
				SetTile(xi,yi, 1,2031);
		}
	}

	SetTile(-128+22+128,64, 1,1910);
	SetTile(-128+23+128,64, 1,2016);
	for (xi=-128+24+128;xi<55+128;xi+=2)
	{
		SetTile(xi,64, 1,2015);
		SetTile(xi+1,64, 1,2016);
	}

	for (xi=-128+23+128;xi<48+128;xi+=4)
	{
		SetTile(xi,73, 1,2028);
		SetTile(xi+1,73, 1,2025);
		SetTile(xi+2,73, 1,2026);
		SetTile(xi+3,73, 1,2027);
	}

	for (xi=-128+23+128;xi<48+128;xi++)
	{
		for (yi=23;yi<48;yi++)
		{
			if ((xi+yi)%2 == 0)
				SetTile(xi,yi, 1,2030);
			else
				SetTile(xi,yi, 1,2031);
		}
	}
	for (xi=-128+23+128;xi<48+128;xi++)
	{
		for (yi=74;yi<76;yi++)
		{
			if ((xi+yi)%2 == 0)
				SetTile(xi,yi, 1,2030);
			else
				SetTile(xi,yi, 1,2031);
		}
	}
/*
	SetTile(22+128,65, 1,1909);
	SetTile(22+128,66, 1,1914);
	SetTile(22+128,67, 1,1909);
	SetTile(22+128,68, 1,1916);
*/
	ResetBoss2();
	g_boss_active = 2;
	SetLayerRenderer(2, "");
	SetLayerRenderer(4, "DrawBoss2();");
	
	
	doors[0].x = blood_dx;
	doors[1].x = blood_dx;
	SetPersonIDX(doors[0].id1, blood_dx);
	SetPersonIDX(doors[1].id1, blood_dx);
	
}



//BOSS 2 code:
var boss2 = new Object();

boss2.x = 72*16+128*16;
boss2.y = 65*16;
boss2.dir = -1;
boss2.dirt = "idle";
boss2.framet = 0;
boss2.dirl = "walk";
boss2.framel = 0;
boss2.counter = 0;


var boss_legs = new Array();
boss_legs[0] = LoadImage("boss2/boss2_bom_01.png");
boss_legs[1] = LoadImage("boss2/boss2_bom_02.png");
boss_legs[2] = LoadImage("boss2/boss2_bom_03.png");
boss_legs[3] = LoadImage("boss2/boss2_bom_04.png");
boss_legs[4] = LoadImage("boss2/boss2_bom_05.png");
boss_legs[5] = LoadImage("boss2/boss2_bom_06.png");
boss_legs[6] = LoadImage("boss2/boss2_bom_07.png");
boss_legs[7] = LoadImage("boss2/boss2_bom_08.png");
boss_legs[8] = LoadImage("boss2/boss2_bom_09.png");
boss_legs[9] = LoadImage("boss2/boss2_bom_10.png");

var boss_idle = new Array();
boss_idle[0] = LoadImage("boss2/boss2_top_01.png");
boss_idle[1] = LoadImage("boss2/boss2_top_02.png");
boss_idle[2] = LoadImage("boss2/boss2_top_03.png");

var boss_punch = new Array();
boss_punch[0] = LoadImage("boss2/boss2_top_04.png");
boss_punch[1] = LoadImage("boss2/boss2_top_05.png");
boss_punch[2] = LoadImage("boss2/boss2_top_06.png");
boss_punch[3] = LoadImage("boss2/boss2_top_07.png");
boss_punch[4] = LoadImage("boss2/boss2_top_08.png");
boss_punch[5] = LoadImage("boss2/boss2_top_09.png");
boss_punch[6] = LoadImage("boss2/boss2_top_10.png");
boss_punch[7] = LoadImage("boss2/boss2_top_11.png");


var boss_spawn = new Array();
boss_spawn[0] = LoadImage("boss2/boss2_top_12.png");
boss_spawn[1] = LoadImage("boss2/boss2_top_13.png");
boss_spawn[2] = LoadImage("boss2/boss2_top_14.png");
boss_spawn[3] = LoadImage("boss2/boss2_top_15.png");


function ResetBoss2()
{
boss2.x = 70*16+128*16;
boss2.y = 65*16+5;
boss2.dir = -1;
boss2.dirt = "idle";
boss2.framet = 0;
boss2.dirl = "idle";
boss2.framel = 0;
boss2.counter = 0;
boss2.wcounter = 0;
boss2.ptimer = 0;
boss2.ptimermax = 100;

boss2.hp = 15000;//4000; for testing
boss2.maxhp = 15000;

boss2.axoff = 75;
boss2.ayoff = 64;
boss2.aw = 24;
boss2.ah = 80;

boss2.attackw = 96;
boss2.attackh = 80;

boss2.stimer = 0;
boss2.stimermax = 150;

boss2.ftimer = 0;
boss2.ftimermax = 75;
boss2.atimer = 0;
boss2.atimermax = 450;


boss2.damage =0.85;
g_boss_cc = g_boss_norm;
}

boss_disengage = 30*16+240;
boss_drop_percent = 0.3;

function DrawBoss2()
{
	//draw the legs:
	if (boss2.dirl == "idle")
		boss_legs[0].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));
	else if (boss2.dirl == "walk")
		boss_legs[boss2.framel].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));

	//draw the torso
	if (boss2.dirt == "idle")
		boss_idle[boss2.framet].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));
	else if (boss2.dirt == "punch")
		boss_punch[boss2.framet].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));
	else if (boss2.dirt == "spawn")
	{
		if (boss2.framet < 4)
			boss_spawn[boss2.framet].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));
		else if (boss2.framet >6)
			boss_spawn[10-boss2.framet].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));
		else
			boss_spawn[3].blit(MapToScreenX(0, boss2.x),MapToScreenY(0, boss2.y));
	}
	
}

//walk forward.
	//if person is close enough to attack then do so.
	
//randomly spawn reworks.


function Boss2Walk()
{
	if (boss2.wcounter == 0)
		boss2.framel = 0;
	boss2.wcounter+=50;
}

function DoBoss2Hp1Damage(damage,x,y)
{
	var sx = -3;
	var sy = -4;
	//spawn some"blood"
	for(dbh=0;dbh<4;dbh++)
	{
		sx=-3;
		if (dbh%2 ==0)
			sx=3;
		SpawnBlood(boss2.x+boss2.axoff,y,sx+Math.random()*4-2,sy+Math.random()*3-2,1, "", undefined,undefined,undefined, true);
	}

	boss2.hp -= damage;
	if (boss2.hp<0)
	{
		boss2.hp = 0;
	}

}


function Boss2Punch()
{
	if (boss2.ptimer <=0 && boss2.dirt == "idle")
	{
		boss2.framet = 0;
		boss2.dirt = "punch";
		boss2.ptimer = Math.floor(boss2.ptimermax*(0.5+Math.random()));
	}
}

var boss2_loc = new Array(6);

for (i=0;i<6;i++)
{
	boss2_loc[i] = new Object();
	boss2_loc[i].x = 0;
	boss2_loc[i].y = 0;
}

var boss2_loc2 = new Array();
for (i=0;i<8;i++)
	boss2_loc2[i] = 0;



function Boss2Spawn()
{
	
	var maxx = Math.floor(boss2.x/16);
	var minx = Math.floor(boss2.x/16)-8;
	var miny = Math.floor(boss2.y/16)+1;
	var maxy = Math.floor(boss2.y/16)+6;
	var temp = 0;
	var bscount = 0;

	for (i=0;i<8;i++)
		boss2_loc2[i]= 0;
	for (i=0;i<6;i++)
	{
		boss2_loc[i].x = minx;
		boss2_loc[i].y = miny+Math.floor(5*Math.random());
	}
	
	
	while(AreKeysLeft())GetKey();


	for (i=0;i<6;i++)
	{
		temp = Math.floor(Math.random()*(8-i));
		bscount = 0;
		for (j=0;j<8;j++)
		{
			if (boss2_loc2[j] == 0)
			{
				if (bscount == temp)
				{
					boss2_loc[i].x = minx+j;
					boss2_loc2[j] = 1;
					break;
				}
				bscount++;
			}
		}
	}
	
	var numy = 45+Math.floor(Math.random()*5);
	
	var num = 45;
	if (numy > 47)
		num = numy-3;
		
	var t1 =0;
	var t2 =0;
		
	for (aia=0;aia<battle_zones[num][0].number;aia++)
	{	
		battle_zones[num][aia+1].stage = 1;
		battle_zones[num][aia+1].ent = ReturnEnt(battle_zones[num][aia+1].name);
		entt=battle_zones[num][aia+1].ent;
		entities[entt].x = boss2_loc[aia].x*16+8;
		entities[entt].y = boss2_loc[aia].y*16+8;

		t1 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y, 1);
		t2 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y+1, 1);

		if (t1 != 2044 && t1 != 2049 && t2 != 2044 && t2 != 2049)
		{
			t1 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y, 2);
			t2 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y+1, 2);
			if (t1 == 0 && t2 == 0)
				EnemyAmbush(battle_zones[num][aia+1].name, battle_zones[num][aia+1].ent,battle_zones[num][aia+1].type,true);
		}
	}
	
	if (numy > 47)
	{
		num = 47;

		for (aia=0;aia<battle_zones[num][0].number;aia++)
		{	
			battle_zones[num][aia+1].stage = 1;
			battle_zones[num][aia+1].ent = ReturnEnt(battle_zones[num][aia+1].name);
			entt=battle_zones[num][aia+1].ent;
			entities[entt].x = boss2_loc[aia+3].x*16+8;
			entities[entt].y = boss2_loc[aia+3].y*16+8;
			
			t1 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y, 1);
			t2 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y+1, 1);

			if (t1 != 2044 && t1 != 2049 && t2 != 2044 && t2 != 2049)
			{
				t1 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y, 2);
				t2 =GetTile(boss2_loc[aia+3].x, boss2_loc[aia+3].y+1, 2);
				if (t1 == 0 && t2 == 0)
					EnemyAmbush(battle_zones[num][aia+1].name, battle_zones[num][aia+1].ent,battle_zones[num][aia+1].type,true);
			}
		}
	}
	boss2.stimer = Math.floor(boss2.stimermax*(0.5+Math.random())/2);

}

function TriggerBoss2Fade()
{
	if (boss2.atimer == 0)
		PlayMusic(1);
		
	if (boss2.atimer < boss2.atimermax)
		boss2.atimer++;
	else
		boss2.ftimer++;
}

function Boss2AI()
{
	if (boss2.x < boss_disengage || boss2.hp < boss_drop_percent*boss2.maxhp)
	{
		TriggerBoss2Fade();
	}

	

	boss2.counter++;
	if (boss2.ptimer > 0)
		boss2.ptimer--;
	if (boss2.stimer > 0)
		boss2.stimer--;

	if (boss2.counter %1==0)
	{
		if (boss2.wcounter > 0)
		{
			boss2.x--;
			boss2.wcounter--;
			boss2.dirl = "walk";
		}
	}
	
	if (boss2.counter %75 ==0)
	{
		Boss2Walk();
	}
	
	if (entities[0].x > boss2.x+32)
	{
		var t_layer = GetPersonIDLayer(entities[0].id1);
		SetPersonIDLayer(entities[0].id1, 0);
		if (IsPersonObstructed(entities[0].name, boss2.x+32, entities[0].y))
			;
		else
			entities[0].x = boss2.x+32;
		SetPersonIDLayer(entities[0].id1, t_layer);
	}
	else if (entities[0].x < boss2.x-160+32 && entities[0].x < 51*16+128*16)
	{
		var t_layer = GetPersonIDLayer(entities[0].id1);
		SetPersonIDLayer(entities[0].id1, 0);
		if (IsPersonObstructed(entities[0].name, boss2.x-160+32, entities[0].y))
			;
		else if (boss2.x-160+32 < 51*16+128*16)
			entities[0].x = boss2.x-160+32;
		else if (entities[0].x < 51*16+128*16)
			entities[0].x = 51*16+128*16;
		SetPersonIDLayer(entities[0].id1, t_layer);
	}


	//check for punch!
	if (Math.abs(boss2.x+boss2.axoff-entities[0].x)<boss2.attackw && boss2.dirt != "punch")
	{
		Boss2Punch();
	}
		
	if (boss2.counter %5 == 0)
	{		
	
		if (boss2.wcounter > 0)
		{
			boss2.dirl = "walk";
			boss2.framel = (boss2.framel+1)%10;
		}
		else
		{
			boss2.dirl = "idle";
			boss2.framel = 0;
		}
		

		if (boss2.dirt == "idle")
			boss2.framet = (boss2.framet+1)%3;
		else if (boss2.dirt == "spawn")
		{
			boss2.framet = (boss2.framet+1)%10;
			if (boss2.framet == 4)
			{
				//spawn it!
				Boss2Spawn();
			}
		}
		else if (boss2.dirt == "punch")
		{
			boss2.framet = (boss2.framet+1)%8;
			
			if (boss2.framet == 4)
			{
				//punch it!
				BossSpriteShoveAttack(false, boss2.damage, false, false);
			}
		}
		if (boss2.framet == 0)
		{

			if (Math.random()<0.5 && boss2.stimer <= 0)
				boss2.dirt = "spawn";
			else
				boss2.dirt = "idle";
		}
	}
///	boss2.dirl = "walk";
}